/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.message;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.toolkit.designer.VWSIMDesignerPreferences;
import filenet.sim.toolkit.designer.message.VWSIMScenarioValidationResultsDialog;
import filenet.sim.toolkit.designer.message.VWSIMValidationPanel;
import filenet.sim.toolkit.designer.message.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class VWSIMDesignerMessagePanel
extends JPanel {
    public static final int DISPLAY_TYPE_PANEL = 0;
    public static final int DISPLAY_TYPE_DIALOG = 1;
    private VWSIMPropertyData m_propertyData = null;
    private VWSIMValidationPanel m_validationPanel = null;
    private VWSIMScenarioValidationResultsDialog m_validationDialog = null;

    public void init(VWSIMPropertyData propertyData, int nDisplayType) {
        try {
            this.m_propertyData = propertyData;
            this.setLayout(new BorderLayout(6, 6));
            switch (nDisplayType) {
                case 0: {
                    this.m_validationPanel = new VWSIMValidationPanel();
                    this.m_validationPanel.init();
                    this.add((Component)this.m_validationPanel, "Center");
                    break;
                }
                case 1: {
                    this.m_validationDialog = new VWSIMScenarioValidationResultsDialog(this.m_propertyData);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean validateScenario(VWSIMPropertyData propertyData, boolean bDisplayMessage) {
        boolean bValid = false;
        try {
            VWScenarioDefinition scenarioDef = propertyData.getScenarioDefinition();
            if (scenarioDef == null) {
                return false;
            }
            boolean bValidateWorkflows = true;
            VWSIMDesignerPreferences preferences = propertyData.getDesignerPreferences();
            if (preferences != null) {
                bValidateWorkflows = preferences.getShouldValidateWorkflowDefsWithScenario();
            }
            if (this.m_validationDialog != null) {
                return this.m_validationDialog.validateScenario(scenarioDef, bDisplayMessage, bValidateWorkflows);
            }
            if (this.m_validationPanel != null) {
                VWScenarioValidationError[] errors = scenarioDef.validate(propertyData.getSessionInfo().getSession(), bValidateWorkflows, propertyData.getSystemConfiguration(), propertyData.getSdfFileContents());
                this.m_validationPanel.setValidationMsg(errors);
                if (errors == null) {
                    if (bDisplayMessage) {
                        VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_validScenarioMessage, 2);
                    }
                    bValid = true;
                } else {
                    int nWarningCount = 0;
                    int nErrorCount = 0;
                    block6: for (int i = 0; i < errors.length; ++i) {
                        switch (errors[i].getLevel()) {
                            case 2: {
                                ++nWarningCount;
                                continue block6;
                            }
                            case 1: {
                                ++nErrorCount;
                            }
                        }
                    }
                    if (nErrorCount > 0 && nWarningCount > 0) {
                        String message = VWSIMResource.s_scenarioContainsErrorsAndWarnings.toString(Integer.toString(nErrorCount), Integer.toString(nWarningCount));
                        VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), message, 1);
                        bValid = false;
                    } else if (nErrorCount > 0) {
                        String message = VWSIMResource.s_scenarioContainsErrors.toString(Integer.toString(nErrorCount));
                        VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), message, 1);
                        bValid = false;
                    } else if (nWarningCount > 0) {
                        if (bDisplayMessage) {
                            String message = VWSIMResource.s_scenarioContainsWarnings.toString(Integer.toString(nWarningCount));
                            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), message, 2);
                        }
                        bValid = true;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            return false;
        }
        return bValid;
    }

    public void releaseReferences() {
        this.m_propertyData = null;
        this.m_validationPanel = null;
        this.m_validationDialog = null;
    }
}

